pro top_level

       ;rates_o   = diffrential Oxygen intensities 
       ;err_o     = statistical uncertainties in Oxygen intensities
       ;not1_mean = mean O energy
       ;not1_lo   = lower energy ranges for O 
       ;not1_hi   = upper energy ranges for O
       ;force_fit = set to > 3 for an exponential fit and le 3 for a power-law fit.
       ;fit parameters, uncertainties, and chisq are given by variable o_params
       
       
       y_values         = alog(rates_o)
       y_error          = err_o/rates_o
       measure_errors   = y_error
       x_values         = not1_mean
       x_min            = not1_lo
       x_max            = not1_hi   
       fit_params       = fltarr(7)
       force_fit        = fltarr(1)
       force_fit        = cnt_o
       
 result = fit_spectrum(x_values,y_values,measure_errors,x_min,x_max,fit_params,force_fit)
 result_a = fit_params(0:2)
 sigma    = fit_params(3:5)       
 chisq    = fit_params(6)     
 
      if (force_fit le 3) then begin       
         for k = 0, 29 do begin
           yy_power(k) = result_a(0) + result_a(1)*alog(xx_power(k)) 
         endfor
       if (force_fit le 2) then begin      
         o_params = [exp(result_a(0)),exp(result_a(0))*sigma(0),-1.*result_a(1),sigma(1),0,0,0.455]
      endif else begin
         o_params = [exp(result_a(0)),exp(result_a(0))*sigma(0),-1.*result_a(1),sigma(1),0,0,chisq]
      endelse         
    endif else begin
         for k = 0, 29 do begin
          yy_power(k) = result_a(0) + result_a(1)*alog(xx_power(k)) + result_a(2)*xx_power(k)
        endfor
       o_params = [exp(result_a(0)),exp(result_a(0))*sigma(0),-1.*result_a(1),sigma(1),-1.0/result_a(2),sigma(2)/result_a(2)^2,chisq]     
   endelse             
       
end       